** "Climate and the emergence of global income differences"
** by Thomas Barnebeck Andersen (SDU), Carl-Johan Dalgaard (UCPH & CEPR), and Pablo Selaya (UCPH)
** Review of Economic Studies
** January 2016

** Tables 3, 4, 8 in the main text
** Tables A1, A3, A4, A6, in the Supplementary Appendix
** Partial correlation plots in the Supplementary Appendix

** Requires ivreg2, outreg2, fsum user-defined Stata routines, which can be installed or updated by typing:
** ssc install ivreg2, replace
** ssc install ranktest, replace
** ssc install outreg2, replace
** ssc install fsum, replace
** It also requires Solomon Hsiang's program ols_spatial_HAC (http://www.fight-entropy.com/2010/06/standard-error-adjustment-ols-for.html)
** by Hsiang, Solomon M. (2010), "Temperatures and cyclones strongly associated with economic production in the Caribbean and Central America", PNAS 107(35): 15367-15372.


clear all
set more off
cap log close
set matsize 800
version 11

*** Set the local download directory ***

local dir `c(pwd)'
cd "`dir'"

*** Define control sets ***

global c2  loglat logelev 
global c3  temp prec 
global c4  logarea dis_ocean dis_major_river distcapital
global all loglat logelev temp prec logarea dis_ocean dis_major_river distcapital


*************************
*** TABLES: MAIN TEXT ***
*************************

*** Table 3 ***

local table 3

** 1x1 **

	use griddata_1x1, clear

		reg logrgdpcap2005 loguv $all, cl(cFE) 
		gen sample`table' = e(sample)

		reg logrgdpcap2005 $all if sample`table', cl(cFE) 
		predict ey if sample`table', resid
		reg loguv $all if sample`table', cl(cFE) 
		predict euv if sample`table', resid
		reg ey euv if sample`table', cl(cFE)
		local pr2 = e(r2)
		ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(cFE) dist(200) 
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		drop ey euv sample
	reg logrgdpcap2005 loguv $all, cl(cFE)
		testparm $all
		local Fp = r(p)
		outreg2 loguv using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(Fp,`Fp',conleyse,`conleyse',pr2,`pr2') addt(cl,`e(clustvar)') ti(Table `table') replace

	foreach fe in cFE lFE {
		areg logrgdpcap2005 loguv $all, cl(`fe') abs(`fe')
		gen sample`table' = e(sample)
		areg logrgdpcap2005 $all if sample`table', cl(`fe') abs(`fe')
		predict ey if sample`table', resid
		areg loguv $all if sample`table', cl(`fe') abs(`fe')
		predict euv if sample`table', resid
		areg ey euv if sample`table', cl(`fe') abs(`fe')
		local pr2 = e(r2)
		ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(`fe') dist(200) 
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		drop ey euv sample
	areg logrgdpcap2005 loguv $all, cl(`fe') abs(`fe')
		testparm $all
		local Fp = r(p)
		outreg2 loguv using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(Fp,`Fp',conleyse,`conleyse',pr2,`pr2',nFE,`e(N_clust)') addt(FE,`fe',cl,`e(clustvar)')
		}
		
** 2x2 & 4x4 **

	foreach g in 2 4 {

	use griddata_`g'x`g', clear

		reg logrgdpcap2005 loguvpopw $all, cl(cFE) 
		gen sample`table' = e(sample)

		reg logrgdpcap2005 $all if sample`table', cl(cFE) 
		predict ey if sample`table', resid
		reg loguvpopw $all if sample`table', cl(cFE) 
		predict euv if sample`table', resid
		reg ey euv if sample`table', cl(cFE)
		local pr2 = e(r2)
		if `g'==2 ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(cFE) dist(400) 
		if `g'==4 ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(cFE) dist(800) 
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		drop ey euv sample
	reg logrgdpcap2005 loguvpopw $all, cl(cFE)
		testparm $all
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(Fp,`Fp',conleyse,`conleyse',pr2,`pr2') addt(cl,`e(clustvar)') 

	foreach fe in cFE lFE {
		areg logrgdpcap2005 loguvpopw $all, cl(`fe') abs(`fe')
		gen sample`table' = e(sample)
		areg logrgdpcap2005 $all if sample`table', cl(`fe') abs(`fe')
		predict ey if sample`table', resid
		areg loguvpopw $all if sample`table', cl(`fe') abs(`fe')
		predict euv if sample`table', resid
		areg ey euv if sample`table', cl(`fe') abs(`fe')
		local pr2 = e(r2)
		if `g'==2 ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(`fe') dist(400) 
		if `g'==4 ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(`fe') dist(800) 
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		drop ey euv sample
	areg logrgdpcap2005 loguvpopw $all, cl(`fe') abs(`fe')
		testparm $all
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(Fp,`Fp',conleyse,`conleyse',pr2,`pr2',nFE,`e(N_clust)') addt(FE,`fe',cl,`e(clustvar)')
		}

		}
		

*** Table 4 ***

local table 4

** 1x1 **

	use griddata_1x1, clear

		reg loglights loguv $all, cl(cFE) 
		gen sample`table' = e(sample)

		reg loglights $all if sample`table', cl(cFE) 
		predict ey if sample`table', resid
		reg loguv $all if sample`table', cl(cFE) 
		predict euv if sample`table', resid
		reg ey euv if sample`table', cl(cFE)
		local pr2 = e(r2)
		ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(cFE) dist(200) 
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		drop ey euv sample
	reg loglights loguv $all, cl(cFE)
		testparm $all
		local Fp = r(p)
		outreg2 loguv using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(Fp,`Fp',conleyse,`conleyse',pr2,`pr2') addt(cl,`e(clustvar)') ti(Table `table') replace

	foreach fe in cFE lFE {
		areg loglights loguv $all, cl(`fe') abs(`fe')
		gen sample`table' = e(sample)
		areg loglights $all if sample`table', cl(`fe') abs(`fe')
		predict ey if sample`table', resid
		areg loguv $all if sample`table', cl(`fe') abs(`fe')
		predict euv if sample`table', resid
		areg ey euv if sample`table', cl(`fe') abs(`fe')
		local pr2 = e(r2)
		ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(`fe') dist(200) 
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		drop ey euv sample
	areg loglights loguv $all, cl(`fe') abs(`fe')
		testparm $all
		local Fp = r(p)
		outreg2 loguv using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(Fp,`Fp',conleyse,`conleyse',pr2,`pr2',nFE,`e(N_clust)') addt(FE,`fe',cl,`e(clustvar)')

		}
		
** 2x2 & 4x4 **

	foreach g in 2 4 {

	use griddata_`g'x`g', clear

		reg loglights loguvpopw $all, cl(cFE) 
		gen sample`table' = e(sample)

		reg loglights $all if sample`table', cl(cFE) 
		predict ey if sample`table', resid
		reg loguvpopw $all if sample`table', cl(cFE) 
		predict euv if sample`table', resid
		reg ey euv if sample`table', cl(cFE)
		local pr2 = e(r2)
		if `g'==2 ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(cFE) dist(400) 
		if `g'==4 ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(cFE) dist(800) 
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		drop ey euv sample
	reg loglights loguvpopw $all, cl(cFE)
		testparm $all
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(Fp,`Fp',conleyse,`conleyse',pr2,`pr2') addt(cl,`e(clustvar)') 

	foreach fe in cFE lFE {
		areg loglights loguvpopw $all, cl(`fe') abs(`fe')
		gen sample`table' = e(sample)
		areg loglights $all if sample`table', cl(`fe') abs(`fe')
		predict ey if sample`table', resid
		areg loguvpopw $all if sample`table', cl(`fe') abs(`fe')
		predict euv if sample`table', resid
		areg ey euv if sample`table', cl(`fe') abs(`fe')
		local pr2 = e(r2)
		if `g'==2 ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(`fe') dist(400) 
		if `g'==4 ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(`fe') dist(800) 
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		drop ey euv sample
	areg loglights loguvpopw $all, cl(`fe') abs(`fe')
		testparm $all
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(Fp,`Fp',conleyse,`conleyse',pr2,`pr2',nFE,`e(N_clust)') addt(FE,`fe',cl,`e(clustvar)')
		}

		}
		

*** Table 8 ***

local table 8

** 1x1 **

	use griddata_1x1, clear

		reg loglights loguv $all if countrycode=="USA", r
		gen sample`table' = e(sample)

		reg loglights $all if sample`table', r
		predict ey if sample`table', resid
		reg loguv $all if sample`table', r
		predict euv if sample`table', resid
		reg ey euv if sample`table', r
		local pr2 = e(r2)
		ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(cFE) dist(200) 
		ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(cFE) dist(200) 
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		drop ey euv sample
	reg loglights loguv $all if countrycode=="USA", r
		testparm $all
		local Fp = r(p)
		outreg2 loguv using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(Fp,`Fp',conleyse,`conleyse',pr2,`pr2') ct(USA) ti(Table `table') replace

		reg loglights loguv $all if countrycode=="CHN", r
		gen sample`table' = e(sample)
		reg loglights $all if sample`table', r
		predict ey if sample`table', resid
		reg loguv $all if sample`table', r
		predict euv if sample`table', resid
		reg ey euv if sample`table', r
		local pr2 = e(r2)
		ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(cFE) dist(200) 
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		drop ey euv sample
	reg loglights loguv $all if countrycode=="CHN", r
		testparm $all
		local Fp = r(p)
		outreg2 loguv using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(Fp,`Fp',conleyse,`conleyse',pr2,`pr2') ct(CHN)
		
	foreach c in USA CHN {
		areg loglights loguv $all if countrycode=="`c'", cl(lFE) abs(lFE)
		gen sample`table' = e(sample)
		areg loglights $all if sample`table', cl(lFE) abs(lFE)
		predict ey if sample`table', resid
		areg loguv $all if sample`table', cl(lFE) abs(lFE)
		predict euv if sample`table', resid
		areg ey euv if sample`table', cl(lFE) abs(lFE)
		local pr2 = e(r2)
		ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(lFE) dist(200) 
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		drop ey euv sample
	areg loglights loguv $all if countrycode=="`c'", cl(lFE) abs(lFE)
		testparm $all
		local Fp = r(p)
		outreg2 loguv using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(Fp,`Fp',conleyse,`conleyse',pr2,`pr2',nFE,`e(N_clust)') addt(FE,lFE,cl,`e(clustvar)') ct(`c')
		}
		
** 2x2 & 4x4 **

	foreach g in 2 4 {
	
	use griddata_`g'x`g', clear
	
	foreach c in USA CHN {
		reg loglights loguvpopw $all if countrycode=="`c'", r
		gen sample`table' = e(sample)
		reg loglights $all if sample`table', cl(cFE) 
		predict ey if sample`table', resid
		reg loguvpopw $all if sample`table', cl(cFE) 
		predict euv if sample`table', resid
		reg ey euv if sample`table', cl(cFE)
		local pr2 = e(r2)
		if `g'==2 ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(cFE) dist(400) 
		if `g'==4 ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(cFE) dist(800) 
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		drop ey euv sample
	reg loglights loguvpopw $all if countrycode=="`c'", r
		testparm $all
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(Fp,`Fp',conleyse,`conleyse',pr2,`pr2') ct(`c')
		}
		
	foreach c in USA CHN {
		areg loglights loguvpopw $all if countrycode=="`c'", cl(lFE) abs(lFE)
		gen sample`table' = e(sample)
		areg loglights $all if sample`table', cl(lFE) abs(lFE)
		predict ey if sample`table', resid
		areg loguvpopw $all if sample`table', cl(lFE) abs(lFE)
		predict euv if sample`table', resid
		areg ey euv if sample`table', cl(lFE) abs(lFE)
		local pr2 = e(r2)
		if `g'==2 ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(lFE) dist(400) 
		if `g'==4 ols_spatial_HAC ey euv const if sample`table', lat(lat) lon(lon) time(year) panel(lFE) dist(800) 
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		drop ey euv sample
	areg loglights loguvpopw $all if countrycode=="`c'", cl(lFE) abs(lFE)
		testparm $all
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(Fp,`Fp',conleyse,`conleyse',pr2,`pr2',nFE,`e(N_clust)') addt(FE,lFE,cl,`e(clustvar)') ct(`c')
		}
		}
		

************************
*** TABLES: APPENDIX ***
************************
		
*** Table A1 ***

local table A1

	use griddata_1x1, clear

		reg loglights portage if Fall_Line, r 
		outreg2 portage using table`table'.xls, nonot nocon br auto(2) rdec(2) ct(drop) nor2 ti(Table `table') replace 

	foreach dep in loglights loguv {
	foreach c in " " loglat "loglat logelev" {
		ivreg2 `dep' portage `c', partial(`c')
		local pr2 = e(r2c)		
		ols_spatial_HAC `dep' portage `c' const, lat(lat) lon(lon) time(year) panel(cFE) dist(200) 
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
	reg `dep' portage `c' if Fall_Line, r 
		outreg2 portage using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`e(df_m)'-1,pr2,`pr2') addt(conleyse,`conleyse')
		}
		}
		

*** Table A3 ***

local table A3

	use griddata_1x1, clear

		reg loglights loguv $all, r
		gen sample`table' = e(sample)
		outreg2 $all using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(drop) ti(Table `table') replace

	foreach c in c2 c3 c4 all {
	reg loguv $`c' if sample`table', r
		testparm $`c'
		outreg2 using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',F,`r(p)') 
		}

	foreach g in 2 4 {

	use griddata_`g'x`g', clear

		reg loglights loguvpopw $all, r
		gen sample`table' = e(sample)

	foreach c in c2 c3 c4 all {
	reg loguvpopw $`c' if sample`table', r
		testparm $`c'
		outreg2 using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',F,`r(p)') 
		}
		}
		

*** Table A4 ***

local table A4

	use griddata_1x1, clear
	
		reg loglights loguv $all, r
		gen sample`table' = e(sample)
		outreg2 $all using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(drop) ti(Table `table') replace

	foreach fe in cFE lFE {
	areg loguv $all if sample`table', cl(`fe') abs(`fe')
		testparm $all
		outreg2 using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',F,`r(p)',nFE,`e(N_clust)') addt(FE,`e(absvar)')
		}

	foreach g in 2 4 {

	use griddata_`g'x`g', clear

		reg loglights loguvpopw $all, r
		gen sample`table' = e(sample)

	foreach fe in cFE lFE {
	areg loguvpopw $all if sample`table', cl(`fe') abs(`fe')
		testparm $all
		outreg2 using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',F,`r(p)',nFE,`e(N_clust)') addt(FE,`e(absvar)')
		}
		}
		

*** Table A6 ***

local table A6

	use griddata_1x1, clear
	
		reg logrgdpcap2005 loguv $all, r
		gen sample`table'rgdpcap = e(sample)
		reg loglights loguv $all, r
		gen sample`table'lights = e(sample)		
	
	local var0 rgdpcap2005 
	local var1 lightsf152004_raw uv lat elev area dis_ocean dis_major_river distcapital

	log using table`table'.xls, replace text
		// 1x1 degree
		noi fsum `var0' if sample`table'rgdpcap, stat(n mean median sd min max) label
		noi fsum `var1' if sample`table'lights, stat(n mean median sd min max) label
	log close
		
	foreach g in 2 4 {

	use griddata_`g'x`g', clear

		reg logrgdpcap2005 loguvpopw $all, r
		gen sample`table'rgdpcap = e(sample)
		reg loglights loguvpopw $all, r
		gen sample`table'lights = e(sample)

	local var0 rgdpcap2005 
	local var1 lightsf152004_raw uvpopw lat elev area dis_ocean dis_major_river distcapital

	log using table`table'.xls, append text
		// `g'x`g' degree
		noi fsum `var0' if sample`table'rgdpcap, stat(n mean median sd min max) label
		noi fsum `var1' if sample`table'lights, stat(n mean median sd min max) label
	log close
	}
	

*** Figures Appendix ***

local figures appendix

	use griddata_1x1, clear
	reg logrgdpcap2005 loguv $all, cl(cFE)
	avplot loguv, yti("log Real GDP per cap, 2005") xti("log UV | all controls [1x1 grid]") saving(Fig_Table3_col1, replace) nodraw

	use griddata_2x2, clear
	reg logrgdpcap2005 loguvpopw $all, cl(cFE)
	avplot loguvpopw, yti("log Real GDP per cap, 2005") xti("log UV (pop w.) | all controls [2x2 grid]") saving(Fig_Table3_col4, replace) nodraw

	use griddata_4x4, clear
	reg logrgdpcap2005 loguvpopw $all, cl(cFE)
	avplot loguvpopw, yti("log Real GDP per cap, 2005") xti("log UV (pop w.) | all controls [4x4 grid]") saving(Fig_Table3_col7, replace) nodraw

	use griddata_1x1, clear
	xi: reg logrgdpcap2005 loguv $all i.cFE, cl(cFE) 
	avplot loguv, yti("log Real GDP per cap, 2005") xti("log UV | all controls + country FEs [1x1 grid]") saving(Fig_Table3_col2, replace) nodraw

	use griddata_2x2, clear
	xi: reg logrgdpcap2005 loguvpopw $all i.cFE, cl(cFE)
	avplot loguvpopw, yti("log Real GDP per cap, 2005") xti("log UV (pop w.) | all controls + country FEs [2x2 grid]") saving(Fig_Table3_col5, replace) nodraw

	use griddata_4x4, clear
	xi: reg logrgdpcap2005 loguvpopw $all i.cFE, cl(cFE)
	avplot loguvpopw, yti("log Real GDP per cap, 2005") xti("log UV (pop w.) | all controls + country FEs [4x4 grid]") saving(Fig_Table3_col8, replace) nodraw
	
